﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Uploader.aspx.cs" Inherits="GUI.Web.Base.Uploader" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>File upload</title>
    <script>
        // polyfill for endswith, it is browser incompatible with IE
        if (!String.prototype.endsWith)
            String.prototype.endsWith = function (searchStr, Position) {
                // This works much better than >= because
                // it compensates for NaN:
                if (!(Position < this.length))
                    Position = this.length;
                else
                    Position |= 0; // round position
                return this.substr(Position - searchStr.length,
                    searchStr.length) === searchStr;
            };

        function postMessage(message) {
            message.contextId = "<%=Request.QueryString["contextId"]%>";
            window.parent.postMessage(JSON.stringify(message), "*");
        }
        function validateFileSizes(fileinput) {
            var totalSize = 0;
            if (fileinput.files) {
                for (var i = 0; i < fileinput.files.length; i++)
                    totalSize += fileinput.files[i].size;
            }
            if (totalSize > <%=MaxFileSize%>) {
                postMessage({
                    command: "ErrorSelectedFilesToBig",
                    files: fileinput.files,
                    maxSize: <%=MaxFileSize%>
                });
                return false;
            }
            return true;
        }
        function validateFileExtensions(fileinput) {
            var validExtensions = [<%= ValidExtensions %>];
            if (validExtensions.length > 0) {
                for (var fileI = 0; fileI < fileinput.files.length; fileI++) {
                    var valid = false;
                    for (var extI = 0; extI < validExtensions.length; extI++)
                        valid = valid || fileinput.files[fileI].name.toLowerCase().endsWith(validExtensions[extI]);
                    if (!valid) {
                        postMessage({
                            command: "ErrorInvalidFileExtension",
                            validateFileExtensions: validateFileExtensions,
                            files: fileinput.files
                        });
                        return false;
                    }
                }
            }
            return true;
        }
        function submitFile(fileinput) {
            if (validateFileExtensions(fileinput) && validateFileSizes(fileinput)) {
                var files = [];
                for (var i = 0; i < fileinput.files.length; i++)
                    files.push({ originalFilename: fileinput.files[i].name });

                postMessage({
                    command: "FileUploadStarted",
                    files: files
                });

                document.getElementById("icon_upload").style.display = "none";
                document.getElementById("btn").click();
            }
        }
    </script>

    <style type="text/css">
        body, html {
            background-color: transparent !important;
            background:none !important;
            margin: 0;
            overflow: hidden;
            font-family: LatoWeb,"Segoe UI",Segoe,Tahoma,Helvetica,Arial,sans-serif;
        }

        @font-face {
        	font-family: 'streamline-icons';
        	src: url('./fonts/streamline/streamline-icons.ttf?iyun5n') format('truetype'), url('../../../../fonts/streamline/streamline-icons.woff?iyun5n') format('woff'), url('../../../../fonts/streamline/streamline-icons.svg?iyun5n##{$icon--streamline-font-family}') format('svg');
        	font-weight: normal;
        	font-style: normal;
        	font-display: block;
        }

        /* custom button behaviour from style.scss */

        .btn-default, .btn-default:focus, .btn-default:visited {
            color: #252423;
            border: 1px solid #BEBBB8;
            background-color: transparent!important;
        }

        .btn-default:active, .btn-default:focus:active, .btn-default:focus:hover, .btn-default:hover, .btn-default:visited:active, .btn-default:visited:hover {
            color: #252423;
            border: 1px solid #BEBBB8;
            background-color: #F4F4F4 !important;
        }

        .btn {
            border-radius: 3px!important;
            line-height: 21px!important;
            padding: 9px 12px!important;
            font-size: 15px!important;
        }

        .btn>i, .btn>span {
            padding-right: 8px;
        }

        .streamline.icon-download-bottom::before {
            content: "\e916";
        }

        .streamline::before {
        	/* use !important to prevent issues with browser extensions that change fonts */
        	font-family: 'streamline-icons' !important;
        	speak: none;
        	font-style: normal;
        	font-weight: normal;
        	font-variant: normal;
        	text-transform: none;
        	line-height: 1;
        	/* Better Font Rendering =========== */
        	-webkit-font-smoothing: antialiased;
        	-moz-osx-font-smoothing: grayscale;
        }

        .uploader-form {
            height: 41px;
        }

        .fileinput-button {
            overflow: hidden;
            position: relative;
        }

        .fileinput-button input {
            -ms-filter: 'alpha(opacity=0)';
            cursor: pointer;
            direction: ltr;
            font-size: 200px;
            margin: 0;
            opacity: 0;
            position: absolute;
            right: 0;
            top: 0;
        }

        .fileupload-hidden-button {
            height: 20px;
            width: 40px;
        }

        .submitfile-hidden-button {
            display: none;
            height: 41px;
        }

        input[type="file"] {
            display: none;
        }

        .custom-file-upload {
            display: inline-block;
            cursor: pointer;
        }
    </style>
</head>
<body >
    <form id="form1" runat="server" class="uploader-form">
        <span class="fileinput-button">
            <%--<svg version="1.1" id="icon_upload" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                viewBox="0 0 20 20" style="position:absolute;enable-background: new 0 0 20 20;" xml:space="preserve">
                <g>
                    <path d="M14.9,9.6l-0.7,0.7l-3.6-3.7V18h-1V6.7l-3.6,3.7L5.1,9.6L10,4.8L14.9,9.6z M14.5,2v1h-9V2H14.5z" />
                </g>
            </svg>--%>
            <%--<span style="">Click here</span>--%>
            <label for="file" class="btn btn-default custom-file-upload"><i class="streamline icon-download-bottom"></i>Upload</label>
            <asp:FileUpload runat="server"
                class="fileupload-hidden-button"
                ID="file"
                onchange="submitFile(this);" />
            <asp:Button runat="server"
                ID="btn"
                class="submitfile-hidden-button btn btn-sm"
                ClientIDMode="Static"
                Style="display: none;"
                OnClick="SubmitFile"
                Text="Load" />
        </span>
    </form>
</body>
</html>
